#include <iostream>
#include <cstdio>
#include <vector>
#include <string>
#include <cstring>
#include <cmath>
#include <cstdlib>
#include <algorithm>
using namespace std;



const int maxn = 105;
int a[maxn][maxn];
int degIn[maxn];
bool used[maxn];
const int inf = 1e5;



struct Edge
{
	int to, cap, flow, rid;
	Edge() : to(), cap(), flow(), rid() {}
	Edge(int _to, int _cap, int _rid) : to(_to), cap(_cap), rid(_rid) {}
};

vector <Edge> g[maxn];

void addEdge(int v, int to, int cap)
{
	g[v].push_back(Edge(to, cap, (int) g[to].size() ) );
	g[to].push_back(Edge(v, 0, (int) g[v].size() - 1) );
}


bool dfs(int v, const int &t)
{
	if (v == t)
		return true;
	used[v] = true;
	for (int i = 0; i < (int) g[v].size(); i++)
	{
		if (g[v][i].flow == g[v][i].cap)
			continue;
		int nv = g[v][i].to;
		if (used[nv] )
			continue;
		if (dfs(nv, t) )
		{
			g[v][i].flow++;
			g[nv][g[v][i].rid].flow--;
			return true;
		}
	}
	return false;
}

int findFlow(int s, int t)
{
	int ans = 0;
	while (true)
	{
		memset(used, false, sizeof used);
		if (!dfs(s, t) )
			break;
		ans++;
	}
	return ans;
}


int n;
int cnt[maxn][maxn];

void addOne(int v, int nv, vector <int> &ans)
{
	if (a[v][nv] == n)
	{
		ans.push_back(nv);
		return;
	}
	addOne(v, a[v][nv], ans);
	addOne(a[v][nv], nv, ans);
}

void dfsAns(int v, vector <int> &ans)
{
	for (int nv = 0; nv < n; nv++)
	{
		if (cnt[v][nv] == 0)
			continue;
		cnt[v][nv]--;
		addOne(v, nv, ans);
		dfsAns(nv, ans);
		break;
	}
}

int main()
{
	freopen("inspection.in", "r", stdin);
	freopen("inspection.out", "w", stdout);

	memset(a, -1, sizeof a);
	scanf("%d", &n);
	for (int i = 0; i < n; i++)
	{
		int k;
		scanf("%d", &k);
		for (int j = 0; j < k; j++)
		{
			int x;
			scanf("%d", &x);
			x--;
			cnt[i][x]++;
			a[i][x] = n;
			degIn[x]++;
			degIn[i]--;
		}
	}
	for (int h = 0; h < n; h++)
		for (int i = 0; i < n; i++)
			for (int j = 0; j < n; j++)
			{
				if (a[i][h] != -1 && a[h][j] != -1 && a[i][j] == -1)
				{
					a[i][j] = h;
				}
			}
	int s = n;
	int t = n + 1;
	for (int i = 0; i < n; i++)
	{
		if (degIn[i] > 0)
		{
			addEdge(s, i, degIn[i] );
			for (int j = 0; j < n; j++)
			{
				if (degIn[j] < 0 && a[i][j] != -1)
				{
					addEdge(i, j, inf);
				}
			}
		}
		else if (degIn[i] < 0)
		{
			addEdge(i, t, -degIn[i] );
		}
	}
	findFlow(s, t);
	for (int i = 0; i < n; i++)
	{
		if (degIn[i] <= 0)
			continue;
		for (int j = 0; j < (int) g[i].size(); j++)
		{
			int nv = g[i][j].to;
			if (nv >= n)
				continue;
			degIn[i] -= g[i][j].flow;
			degIn[nv] += g[i][j].flow;
			cnt[i][nv] += g[i][j].flow;
		}
	}
	vector <vector <int> > answer;
	for (int i = 0; i < n; i++)
	{
		for (int j = 0; j < -degIn[i]; j++)
		{
			vector <int> v;
			v.push_back(i);
			dfsAns(i, v);
			answer.push_back(v);
		}
	}
	printf("%d\n", (int) answer.size() );
	for (int i = 0; i < (int) answer.size(); i++)
	{
		for (int j = 0; j < (int) answer[i].size(); j++)
		{
			printf("%d ", answer[i][j] + 1);
		}
		printf("\n");
	}

	return 0;
}
